/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp;

import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.InPlanStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreActivityOwner;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.store.StoreType;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MrpAlgorithms {
    private static final Logger log = LoggerFactory.getLogger(MrpAlgorithms.class);

    public static boolean checkSanity(Superplan superplan, boolean checkOnlyProposed) {
        StoreSchedule s2 = superplan.getPlan().getStoreSchedule(StoreType.POSSIBLE_ESTIMATE_VIEW);
        int totalCnt = 0;
        int invalidCnt = 0;
        for (Material m3 : s2.getMaterials()) {
            if (!m3.isConsumed()) continue;
            double llim = m3.getSafetyStock();
            double ulim = m3.getSafetyStock() + MrpAlgorithms.getMargin(m3);
            double q = s2.getInfTimeQty(m3);
            boolean hasProposed = false;
            for (StoreActivity sa : s2.getActivities(m3)) {
                if (!(sa instanceof InPlanStoreActivity)) continue;
                StoreActivityOwner owner = ((InPlanStoreActivity)sa).getOwner();
                if (owner instanceof SupplyRequest) {
                    if (((SupplyRequest)owner).getState() != SupplyRequest.State.PROPOSED || !(sa.getQty() > 0.0)) continue;
                    hasProposed = true;
                    break;
                }
                if (!(owner instanceof GeneralizedOrderRequest) || ((GeneralizedOrderRequest)owner).getState() != GeneralizedOrderRequest.State.PROPOSED || !(sa.getQty() > 0.0)) continue;
                hasProposed = true;
                break;
            }
            if (checkOnlyProposed && !hasProposed) continue;
            if (q > ulim + 1.0E-7 || q < llim - 1.0E-7) {
                log.info("{} (ll:{}, ul:{}, min: {}, bs: {}): {}", m3, llim, ulim, m3.getMinBatch(), m3.getBatchStep(), q);
                ++invalidCnt;
            }
            ++totalCnt;
        }
        log.info("{}/{}", (Object)invalidCnt, (Object)totalCnt);
        return invalidCnt == 0;
    }

    private static double getMargin(Material m3) {
        double mb = m3.getMinBatch();
        double bs = m3.getBatchStep();
        double margin = mb;
        if (mb == 0.0) {
            margin = bs;
        } else if (mb % bs > 1.0E-7 && mb % bs < bs - 1.0E-7) {
            margin = mb + bs;
        }
        return margin;
    }
}

